/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.microedition.lcdui.Graphics;
import org.microemu.device.MutableImage;
import org.microemu.device.j2se.J2SEDisplayGraphics;
import org.microemu.log.Logger;

public class J2SEMutableImage
extends MutableImage {
    private BufferedImage a;
    private PixelGrabber b = null;
    private int[] c;

    public J2SEMutableImage(int n2, int n3) {
        this.a = new BufferedImage(n2, n3, 1);
        java.awt.Graphics graphics = this.a.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n2, n3);
    }

    public Graphics getGraphics() {
        Object object = (Graphics2D)this.a.getGraphics();
        ((java.awt.Graphics)object).setClip(0, 0, this.getWidth(), this.getHeight());
        object = new J2SEDisplayGraphics((Graphics2D)object, this);
        ((J2SEDisplayGraphics)object).setColor(0);
        Object object2 = object;
        ((J2SEDisplayGraphics)object2).translate(-((Graphics)object2).getTranslateX(), -((Graphics)object).getTranslateY());
        return object;
    }

    public boolean isMutable() {
        return true;
    }

    public int getHeight() {
        return this.a.getHeight();
    }

    public Image getImage() {
        return this.a;
    }

    public int getWidth() {
        return this.a.getWidth();
    }

    public int[] getData() {
        if (this.b == null) {
            this.c = new int[this.getWidth() * this.getHeight()];
            this.b = new PixelGrabber(this.a, 0, 0, this.getWidth(), this.getHeight(), this.c, 0, this.getWidth());
        }
        try {
            this.b.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            Logger.error(interruptedException);
        }
        return this.c;
    }

    public MutableImage scale(int n2) {
        BufferedImage bufferedImage = new BufferedImage(this.a.getWidth() * n2, this.a.getHeight() * n2, this.a.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(n2, n2);
        graphics2D.drawImage((Image)this.a, 0, 0, null);
        J2SEMutableImage j2SEMutableImage = new J2SEMutableImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        new J2SEMutableImage(bufferedImage.getWidth(), bufferedImage.getHeight()).a = bufferedImage;
        return j2SEMutableImage;
    }

    public void getRGB(int[] object, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        if (n4 < 0 || n5 < 0 || n4 + n6 > this.getWidth() || n5 + n7 > this.getHeight()) {
            throw new IllegalArgumentException("Specified area exceeds bounds of image");
        }
        if ((n3 < 0 ? -n3 : n3) < n6) {
            throw new IllegalArgumentException("abs value of scanlength is less than width");
        }
        if (object == null) {
            throw new NullPointerException("null rgbData");
        }
        if (n2 < 0 || n2 + n6 > ((int[])object).length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 < 0 ? n2 + n3 * (n7 - 1) < 0 : n2 + n3 * (n7 - 1) + n6 > ((int[])object).length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            new PixelGrabber(this.a, n4, n5, n6, n7, (int[])object, n2, n3).grabPixels();
            return;
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            Logger.error(interruptedException);
            return;
        }
    }
}

