/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.log;

import java.io.PrintStream;
import org.microemu.log.LoggerAppender;
import org.microemu.log.LoggingEvent;

public class StdOutAppender
implements LoggerAppender {
    public static boolean enabled = true;

    public static String formatLocation(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return "";
        }
        return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
    }

    public void append(LoggingEvent loggingEvent) {
        String string;
        if (!enabled) {
            return;
        }
        PrintStream printStream = System.out;
        if (loggingEvent.getLevel() == 4) {
            printStream = System.err;
        }
        String string2 = "";
        if (loggingEvent.hasData()) {
            string2 = " [" + loggingEvent.getFormatedData() + "]";
        }
        if ((string = StdOutAppender.formatLocation(loggingEvent.getLocation())).length() > 0) {
            string = "\n\t  " + string;
        }
        printStream.println(loggingEvent.getMessage() + string2 + string);
        if (loggingEvent.getThrowable() != null) {
            loggingEvent.getThrowable().printStackTrace(printStream);
        }
    }
}

